package gov.va.vinci.dart.rule;

import java.util.Map;

import org.springframework.security.core.context.SecurityContextHolder;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Participant;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.service.DartObjectFactory;
import gov.va.vinci.dart.usr.CustomAuthentication;

public class TestSASGridDocumentRuleEvaluator extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
		
		CustomAuthentication token = new CustomAuthentication("DNS", null, "password", "details", "principal");

		try {
			DartObjectFactory.getInstance().getUserManager().login(token);
			SecurityContextHolder.getContext().setAuthentication(token);
		} 
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Test
	public void testOne() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);
		
		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		SASGridDocumentRuleEvaluator testable = new SASGridDocumentRuleEvaluator();
		
		// non-primary site
		Location site = Location.findById(2);
		Location primarySite = Location.findById(1);
		
		Map<Integer, DocumentTemplate> map = TestAbstractDocumentRuleEvaluator.getDocumentTemplateHash();
		
		// loop on all data sources in a request, all sites in a request, and *all* document templates
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), site, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), site, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), site, false));
		
		// if a HIPAA waiver is required?
		((DartRequest)req).setHipaaWaiver(true);
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), site, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), site, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), site, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(13), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), site, false));
		
		// and the primary site?
		((DartRequest)req).setHipaaWaiver(false);
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), primarySite, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), primarySite, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), primarySite, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), primarySite, false));

		// if HIPAA consent required?
		((DartRequest)req).setHipaaConsent(true);
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), primarySite, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(7), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), primarySite, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), primarySite, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), primarySite, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), primarySite, false));
		
		// if HIPAA consent and HIPAA waiver required?
		((DartRequest)req).setHipaaConsent(true);
		((DartRequest)req).setHipaaWaiver(true);
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), primarySite, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), primarySite, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(7), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), primarySite, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), primarySite, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), primarySite, false));  
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(13), primarySite, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), primarySite, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), primarySite, false));

	}

	@Test
	public void testTwo() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);
		
		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		SASGridDocumentRuleEvaluator testable = new SASGridDocumentRuleEvaluator();
		
		Group ordGroup = DartObjectFactory.getInstance().getGroupDAO().findById(7);
		Group privacyGroup = DartObjectFactory.getInstance().getGroupDAO().findById(3);
		Group ndsGroup = DartObjectFactory.getInstance().getGroupDAO().findById(1);
		
		Location site = Location.findById(2);
		Location primarySite = Location.findById(1);
		
		// loop on all data sources in a request, all sites in a request, and *all* document templates

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, primarySite, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, primarySite, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, primarySite, false));

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, site, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, site, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, site, false));
	}

	@Test
	public void testThree() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);

		// non-primary site
		Location site = Location.findById(2);
		Location primarySite = Location.findById(1);

		// request needs two participants
		Person pers1 = Person.findById(1004);  // primary investigator primary site
		Person pers2 = Person.findById(1005);  // primary site no data access
		Person pers3 = Person.findById(1006);  // primary investigator non-primary site
		Person pers4 = Person.findById(1008);  // non-primary site no data access
		Person pers5 = Person.findById(1014);  // non-primary site with data access

		Participant participant1 = Participant.create(pers1, req, primarySite, true, true, true);
		Participant participant2 = Participant.create(pers2, req, primarySite, false, false, false);
		Participant participant3 = Participant.create(pers3, req, site, true, true, true);
		Participant participant4 = Participant.create(pers4, req, site, false, false, false);
		Participant participant5 = Participant.create(pers5, req, site, true, true, false);

		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		SASGridDocumentRuleEvaluator testable = new SASGridDocumentRuleEvaluator();

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, participant1, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, participant3, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, participant5, false));
	}

	@Test
	public void testFour() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);

		// non-primary site
		Location site = Location.findById(2);
		Location primarySite = Location.findById(1);

		// request needs two participants
		Person pers1 = Person.findById(1004);  // primary investigator primary site
		Person pers2 = Person.findById(1005);  // primary site no data access
		Person pers3 = Person.findById(1006);  // primary investigator non-primary site
		Person pers4 = Person.findById(1008);  // non-primary site no data access
		Person pers5 = Person.findById(1014);  // non-primary site with data access
		
		Participant participant1 = Participant.create(pers1, req, primarySite, true, true, true);
		Participant participant2 = Participant.create(pers2, req, primarySite, false, false, false);
		Participant participant3 = Participant.create(pers3, req, site, true, true, true);
		Participant participant4 = Participant.create(pers4, req, site, false, false, false);
		Participant participant5 = Participant.create(pers5, req, site, true, true, false);

		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		SASGridDocumentRuleEvaluator testable = new SASGridDocumentRuleEvaluator();
		
		Group ordGroup = DartObjectFactory.getInstance().getGroupDAO().findById(7);
		Group privacyGroup = DartObjectFactory.getInstance().getGroupDAO().findById(3);
		Group ndsGroup = DartObjectFactory.getInstance().getGroupDAO().findById(1);
		
		// loop on all data sources in a request, all sites in a request, and *all* document templates

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant1, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant3, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant5, false));
		
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant1, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant3, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant5, false));

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant3, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant5, false));
	}
}
